function ObjectAnalyzer()

global Prefs;

% Get Analysis default Prefs from Excel file
%Prefs.SampleRate = N(1); % This must still be modified!!


 currentFolder = pwd;
 folder =mfilename('fullpath');
 folder = folder(1:length(folder)- 14);
  
 cd (folder)


ExcelFileName = 'Object Analyzer Preferences.xls';
WorkSheet = 'Sheet1';
[N, T, D] = xlsread(ExcelFileName, WorkSheet);

if (isunix)

Prefs.SampleRate = N(1,2); 
Prefs.SmoothWinSize = N(2,2);
Prefs.StepSize = N(3,2);
Prefs.PlotDirection = N(4,2);
Prefs.PlotSpeed = N(5,2);
Prefs.PlotAngSpeed = N(6,2);
Prefs.PirThresh = N(7,2);
Prefs.MaxShortRun = N(8,2);
Prefs.FFSpeed = N(9,2);
Prefs.PixelSize = 1/N(10,2);
Prefs.BinSpacing = N(11,2);
Prefs.MaxSpeedBin = N(12,2);
Prefs.P_MaxSpeed = N(13,2);
Prefs.P_TrackFraction = N(14,2);
Prefs.P_WriteExcel = N(15,2);
Prefs.DefaultPath = T{16,2};
if exist(Prefs.DefaultPath, 'dir') 
    cd(Prefs.DefaultPath);
end

  cd (currentFolder)


end
if (ispc)

Prefs.SampleRate = N(1); % This must still be modified!!
Prefs.SmoothWinSize = N(2);
Prefs.StepSize = N(3);
Prefs.PlotDirection = N(4);
Prefs.PlotSpeed = N(5);
Prefs.PlotAngSpeed = N(6);
Prefs.PirThresh = N(7);
Prefs.MaxShortRun = N(8);
Prefs.FFSpeed = N(9);
Prefs.PixelSize = 1/N(10);
Prefs.BinSpacing = N(11);
Prefs.MaxSpeedBin = N(12);
Prefs.P_MaxSpeed = N(13);
Prefs.P_TrackFraction = N(14);
Prefs.P_WriteExcel = N(15);

% Set Matlab's current directory
 Prefs.DefaultPath = T{16,2};
if exist(Prefs.DefaultPath, 'dir') 
    cd(Prefs.DefaultPath);
end

  cd (currentFolder)

end         
% Create Main Track Analysis Window
% ---------------------------------
Prefs.FigH = figure('Name', 'Object Analyzer', ...
	'NumberTitle', 'off', ...
    'Position', [165 150 880 660], ...
    'Resize', 'Off', ...
	'Tag', 'MAINFIG');

TrackH = uimenu(Prefs.FigH, 'label', 'Tracks');

OpenH = uimenu(TrackH, 'label', 'Open Tracks File', ...
	'callback', 'OpenTrack;');

Analyze_TrackH = uimenu(TrackH, 'label', 'Analyze Current Track', ...
	'tag', 'ANALYZE', ...
	'enable', 'off', ...
	'callback', 'TrackAnalysis;');

BatchH = uimenu(TrackH, 'label', 'Analyze All Tracks', ...
    'tag', 'BATCH', ...
    'enable', 'off', ...
    'callback', 'BatchAnalyzer');

SaveH = uimenu(TrackH, 'label', 'Save Tracks File', ...
	'tag', 'SAVE', ...
	'enable', 'off', ...
	'callback', 'SaveResults');

DispPirH = uimenu(TrackH, 'label', 'Display Pirouettes', ...
	'tag', 'DISPPIR', ...
	'enable', 'on', ...
    'callback', 'DisplayPirouettes');

SpeedHistH = uimenu(TrackH, 'label', 'Plot Speed Histogram', ...
	'tag', 'SPEED_HIST', ...
	'enable', 'on');
   SingleSpeedHistH  = uimenu(SpeedHistH, 'label', 'Current Tracks File', ...
       'tag', 'SINGLE_SPEED_HIST', ...
       'enable', 'off', ...
       'callback', 'PlotSpeedHistogram(''Single'')');
   MultSpeedHistH = uimenu(SpeedHistH, 'label', 'Select Multiple Tracks Files', ...
       'tag', 'MULT_SPEED_HIST', ...
       'enable', 'on', ...
       'callback', 'PlotSpeedHistogram(''Multiple'')');

IDParalysisH = uimenu(TrackH, 'label', 'Analyze Paralysis', ...
	'tag', 'ID_PARAL', ...
	'enable', 'on');
   SingleIDParalysisH  = uimenu(IDParalysisH, 'label', 'Current Tracks File', ...
       'tag', 'SINGLE_ID_PARAL', ...
       'enable', 'off', ...
       'callback', 'IdentifyParalyzed(''Single'')');
   MultIDParalysisH = uimenu(IDParalysisH, 'label', 'Select Multiple Tracks Files', ...
       'tag', 'MULT_ID_PARAL', ...
       'enable', 'on', ...
       'callback', 'IdentifyParalyzed(''Multiple'')');

PrefsH = uimenu(TrackH, 'label', 'Preferences', ...
	'callback', 'TrackAnalysisPrefs');
ExitH = uimenu(TrackH, 'label', 'Exit', ...
	'callback', 'close(findobj(''tag'', ''MAINFIG''));');


% Create interface for playing back tracks
% ----------------------------------------
BeginH = uicontrol(Prefs.FigH, 'string', '|<<', ...
    'tag', 'BEGIN', ...
    'enable', 'off', ...
    'style', 'pushbutton', ...
    'Position', [0 630 30 30], ...
    'callback', 'BeginTrack');
RWH = uicontrol(Prefs.FigH, 'string', '<<', ...
    'tag', 'RW', ...
    'enable', 'off', ...
    'style', 'pushbutton', ...
    'Position', [30 630 30 30], ...
    'callback', 'PlayTrack(''RW'')');
BackH = uicontrol(Prefs.FigH, 'string', '<', ...
    'tag', 'BACK', ...
    'enable', 'off', ...
    'style', 'pushbutton', ...
    'Position', [60 630 30 30], ...
    'callback', 'PlayTrack(''BACK'')');
StopH = uicontrol(Prefs.FigH, 'string', '| |', ...
    'tag', 'STOP', ...
    'enable', 'off', ...
    'style', 'pushbutton', ...
    'Position', [90 630 30 30], ...
    'callback', 'StopTrack');
PlayH = uicontrol(Prefs.FigH, 'string', '>', ...
    'tag', 'PLAY', ...
    'enable', 'off', ...
    'style', 'pushbutton', ...
    'Position', [120 630 30 30], ...
    'callback', 'PlayTrack(''PLAY'')');
FFH = uicontrol(Prefs.FigH, 'string', '>>', ...
    'tag', 'FF', ...
    'enable', 'off', ...
    'style', 'pushbutton', ...
    'Position', [150 630 30 30], ...
    'callback', 'PlayTrack(''FF'')');
EndH = uicontrol(Prefs.FigH, 'string', '>>|', ...
    'tag', 'END', ...
    'enable', 'off', ...
    'style', 'pushbutton', ...
    'Position', [180 630 30 30], ...
    'callback', 'EndTrack');

% Create interface for displaying current frame numbers
% -----------------------------------------------------
FrameH = uicontrol(Prefs.FigH, 'string', 'Frame:', ...
    'tag', 'FRAME', ...
    'style', 'text', ...
    'BackgroundColor', [0.8 0.8 0.8], ...
    'HorizontalAlignment', 'left', ...
    'Position', [270 625 40 30]);
FrameNumH = uicontrol(Prefs.FigH, 'string', '0', ...
    'tag', 'FRAMENUM', ...
    'style', 'text', ...
    'BackgroundColor', [0.8 0.8 0.8], ...
    'HorizontalAlignment', 'left', ...
    'Position', [350 625 40 30]);
%    'ForegroundColor', [1 0 0], ...
FrameTotalH = uicontrol(Prefs.FigH, 'string', 'of    0', ...
    'tag', 'FRAMETOTAL', ...
    'style', 'text', ...
    'BackgroundColor', [0.8 0.8 0.8], ...
    'HorizontalAlignment', 'left', ...
    'Position', [400 625 60 30]);

% Create interface for displaying elapsed time
% --------------------------------------------
TimeH =  uicontrol(Prefs.FigH, 'string', 'Time Elapsed:', ...
    'tag', 'TIME', ...
    'style', 'text', ...
    'BackgroundColor', [0.8 0.8 0.8], ...
    'HorizontalAlignment', 'left', ...
    'Position', [270 615 80 15]);
TimeElapsedH =  uicontrol(Prefs.FigH, 'string', '0', ...
    'tag', 'TIMEELAPSED', ...
    'style', 'text', ...
    'BackgroundColor', [0.8 0.8 0.8], ...
    'HorizontalAlignment', 'left', ...
    'Position', [350 615 40 15]);
SecondsH =  uicontrol(Prefs.FigH, 'string', 'Seconds', ...
    'tag', 'SECONDS', ...
    'style', 'text', ...
    'BackgroundColor', [0.8 0.8 0.8], ...
    'HorizontalAlignment', 'left', ...
    'Position', [390 615 50 15]);


% Create interface for selecting tracks
% -------------------------------------
SliderH = uicontrol(Prefs.FigH, ...
    'tag', 'SLIDER', ...
    'enable', 'off', ...
    'style', 'slider', ...
    'Min',0,...
    'Max',1,...
    'Value',0.5,...
    'SliderStep',[0.1 0.1],...
    'Position', [500 640 360 20] ,  ...  
    'callback', 'SelectTrack');


SliderTitleH = uicontrol(Prefs.FigH, 'string', 'Track No.', ...
    'tag', 'SLIDERTITLE', ...
    'style', 'text', ...
    'BackgroundColor', [0.8 0.8 0.8], ...
    'Position', [500 625 380 15]);


% Create interface for deleting tracks
% ------------------------------------
DeleteH = uicontrol(Prefs.FigH, 'string', 'Delete Track', ...
    'tag', 'DELETE', ...
    'enable', 'off', ...
    'style', 'pushbutton', ...
    'Position', [780 610 100 20], ...
    'callback', 'DeleteTrack');

